<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'user';
    public $timestamps = true;

    public function user()
    {
        return $this->hasMany('Task', 'owner_id');
    }

    public function calculation()
    {
        return $this->hasOne('Wallet', 'user_id');
    }

    public function recharge()
    {
        return $this->hasOne('Claim', 'user_id');
    }

    public function takeHaram()
    {
        return $this->hasOne('Redeem', 'user_id');
    }

    public function issue()
    {
        return $this->hasOne('Issue', 'user_id');
    }

    public function execute_user()
    {
        return $this->hasOne('TaskExecution', 'executor_id');
    }

    public function address()
    {
        return $this->hasOne('Address', 'user_id');
    }

    public function notification()
    {
        return $this->hasOne('Notification', 'user_id');
    }

}